<?php

namespace App\Controller;

use App\Entity\Serial;
use App\Form\SerialType;
use App\Repository\SerialRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/serial")
 */
class SerialController extends AbstractController
{
    /**
     * @Route("/", name="app_serial_index", methods={"GET"})
     */
    public function index(SerialRepository $serialRepository): Response
    {
        return $this->render('serial/index.html.twig', [
            'serials' => $serialRepository->findAll(),
        ]);
    }

    /**
     * @Route("/new", name="app_serial_new", methods={"GET", "POST"})
     */
    public function new(Request $request, SerialRepository $serialRepository): Response
    {
        $serial = new Serial();
        $form = $this->createForm(SerialType::class, $serial);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $serialRepository->add($serial, true);

            return $this->redirectToRoute('app_serial_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('serial/new.html.twig', [
            'serial' => $serial,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_serial_show", methods={"GET"})
     */
    public function show(Serial $serial): Response
    {
        return $this->render('serial/show.html.twig', [
            'serial' => $serial,
        ]);
    }

    /**
     * @Route("/{id}/edit", name="app_serial_edit", methods={"GET", "POST"})
     */
    public function edit(Request $request, Serial $serial, SerialRepository $serialRepository): Response
    {
        $form = $this->createForm(SerialType::class, $serial);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $serialRepository->add($serial, true);

            return $this->redirectToRoute('app_serial_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('serial/edit.html.twig', [
            'serial' => $serial,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_serial_delete", methods={"POST"})
     */
    public function delete(Request $request, Serial $serial, SerialRepository $serialRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$serial->getId(), $request->request->get('_token'))) {
            $serialRepository->remove($serial, true);
        }

        return $this->redirectToRoute('app_serial_index', [], Response::HTTP_SEE_OTHER);
    }
}
